-- jadeja sprint
  set sql_safe_updates=0;
 
  -- GRADEBOOK_PUBLISH_TO_STUDENT
   
SET @gradeBookPTSId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GRADEBOOK_PUBLISH_TO_STUDENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
	T5.id AS ID,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
	T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
	T6.userId As STUDENT_ID,
     ml.code as LANGUAGE_KEY
FROM
    admission T5 
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
    	LEFT JOIN
	multi_language ml on ml.id=T7.correspondence_language
WHERE T5.id IN (namedParams)" WHERE `dataProviderId`=@gradeBookPTSId;   
	

  -- GRADEBOOK_PUBLISH_TO_PARENT
   
SET @gradeBookPTPId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GRADEBOOK_PUBLISH_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T1.printName AS PRINT_NAME,
    T1.emailId AS EMAIL_ID,
    T1.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T1.mobileNumber AS MOBILE_NO,
    T1.mobileCountryCode AS MOBILE_CODE,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T4.userId AS STUDENT_ID,
    ml.code as LANGUAGE_KEY
FROM
    persons T1
        LEFT JOIN
    person_relationships T2 ON T2.relatedPersonId = T1.id
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        LEFT JOIN
    students T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@gradeBookPTPId;   

   -- EXAMINATION_INVIGILATOR_ALLOCATION
   
SET @examinationInvigilatorAllocation=(SELECT id FROM dtprovider WHERE `dataProviderName`='EXAMINATION_INVIGILATOR_ALLOCATION_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="select
        distinct evaluation5_.scheduleDate as EXAM_DATE,
        course14_.courseName as COURSE_NAME,
        invigilato1_.id as ID,
        examcenter7_.centerName as CENTER_NAME,
        p.printName as USER_NAME ,
		centerroom4_.roomNo as ROOM_NAME,
        p.emailId AS EMAIL_ID,
  	    p.mobileNumber AS MOBILE_NO,
        ml.code as LANGUAGE_KEY
    from
        exam_room_invigilator_allocation this_ 
    left outer join
        exam_room_allocation examroomal2_ 
            on this_.roomAllocationId=examroomal2_.id 
    left outer join
        center_room_details centerroom3_ 
            on examroomal2_.externalRoomId=centerroom3_.id 
	left outer join
        center_room_details centerroom4_ 
            on examroomal2_.externalRoomId=centerroom4_.id 
    left outer join
        exam_center examcenter7_ 
            on centerroom3_.examCenterId=examcenter7_.id 
    left outer join
        group_date_batch_center groupdateb4_ 
            on examroomal2_.groupDateBatchCenterId=groupdateb4_.id 
    left outer join
        eval_group_center evaluation8_ 
            on groupdateb4_.evalGroupSchCenterId=evaluation8_.id 
    left outer join
        eval_seq_detail evaluation9_ 
            on evaluation8_.evalSequenceDetailId=evaluation9_.id 
    left outer join
        evaluation_sequence evaluation10_ 
            on evaluation9_.evalSequenceId=evaluation10_.id 
    left outer join
        evaluation_plan_level_two evaluation11_ 
            on evaluation10_.evalPlanLevelTwoId=evaluation11_.id 
    inner join
        evaluation_plan_level_one evaluation12_ 
            on evaluation11_.evalPlanLevelOneId=evaluation12_.id 
    inner join
        evaluation_plan evaluation13_ 
            on evaluation12_.evaluationPlanId=evaluation13_.id 
    inner join
        courses course14_ 
            on evaluation13_.courseId=course14_.id 
    left outer join
        eval_group_sch_date evaluation5_ 
            on groupdateb4_.evalGroupSchDateId=evaluation5_.id 
    left outer join
        supervisor_allocation invigilato1_ 
            on this_.InvigilatorId=invigilato1_.id 
            
		join users u on invigilato1_.userId = u.id
		join staffs s on u.id = s.userId
		join persons p on s.personId=p.id
         LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    invigilato1_.id IN (namedParams)" WHERE `dataProviderId`=@examinationInvigilatorAllocation;   
            
 set sql_safe_updates=1;

